#pragma once
#include <library/cpp/object_factory/object_factory.h>
#include <search/reqparam/reqparam.h>
#include <kernel/qtree/richrequest/richnode.h>
#include <kernel/lemmer/core/langcontext.h>

class IQSRequest {
public:
    virtual const TString& GetQSReq() const = 0;
    virtual TRequestParams& GetRP() const = 0;
    virtual ~IQSRequest() {}
};

class IQSFunction {
public:
    virtual ~IQSFunction() {}
    virtual TRichTreePtr GetFResult(const IQSRequest* cgi, const TLanguageContext& langContext) const = 0;
    virtual TString Name() const = 0;

    typedef NObjectFactory::TObjectFactory<IQSFunction, TString> TFactory;
};

