#include "qs_region_cgi.h"
#include <saas/rtyserver/components/qs/qs_const.h>

TQSFunctionRegionCgi::TFactory::TRegistrator<TQSFunctionRegionCgi> TQSFunctionRegionCgi::Registrator(QS_FUNCTION_CGI);

TRichTreePtr TQSFunctionRegionCgi::GetFResult(const IQSRequest* cgi, const TLanguageContext& langContext) const {
    TReqAttrList ral;
    ral.Add(UTF8ToWide(QSAttr), "ATTR_LITERAL,doc");
    TCreateTreeOptions cto(langContext, &ral);
    return CreateRichTree(UTF8ToWide(QSAttr + ":\"" + cgi->GetQSReq() + "\""), cto).Release();
}
