#pragma once

#include "qs_const.h"

#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/factors/factors_blocks.h>
#include <saas/rtyserver/factors/factors_config.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>

class TQSIndexComponent: public NRTYServer::IIndexComponent {
private:
    typedef NRTYFactors::TQSFactorsHashList TQSFactorsInfo;
private:
    const TRTYServerConfig& Config;
    const TQSFactorsInfo& FactorsInfo;
    TIndexFiles IndexFiles;
    bool FixByFullArchive(const NRTYServer::TNormalizerContext& context) const;

public:
    explicit TQSIndexComponent(const TRTYServerConfig& config);

    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    const TIndexFiles& GetIndexFiles() const override;
    bool CheckConfig() const override { return true; }
    bool DoMerge(const NRTYServer::TMergeContext& context) const override;

    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;

    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    bool GetInfoChecker(NRTYServer::TInfoChecker& info) const override;

    TString GetName() const override {
        return QS_COMPONENT_NAME;
    };

    static TFactory::TRegistrator<TQSIndexComponent> Registrator;

};
