#include <saas/rtyserver_test/ut/common.h>
#include <saas/rtyserver/components/qs/qs_pos_builder.h>

Y_UNIT_TEST_SUITE(TRtyQSTest) {
    Y_UNIT_TEST(TestAddreses) {
        DisableRTYServerLogging();
        TWordPosition hitsLow, hitsHight;
        ui32 docId = 1 << DOC_LEVEL_Bits;
        ui32 position = Max<ui32>();
        UNIT_ASSERT_C(TQSPosBuilder::BuildHits(hitsLow, hitsHight, docId, position), "cannot BuildHits");
        ui32 newPos;
        UNIT_ASSERT_C(TQSPosBuilder::BuildPosition(hitsLow, hitsHight, newPos), "cannot BuildPosition 1");
        UNIT_ASSERT_EQUAL_C(newPos, position, "Invalid position 1");
        UNIT_ASSERT_C(TQSPosBuilder::BuildPosition(hitsHight, hitsLow, newPos), "cannot BuildPosition 2");
        UNIT_ASSERT_EQUAL_C(newPos, position, "Invalid position 2");
    }
};
