#include "data.h"

#include <kernel/multipart_archive/multipart.h>

#include <ysite/yandex/srchmngr/arcmgr.h>

THolder<TArchiveManager> NRTYServer::CreateArchiveData(const TString& index) try {
    if (NFs::Exists(index + "arc")) {
        return MakeHolder<TArchiveManager>(index, AOM_FILE, AT_FLAT);
    } else if (TArchiveOwner::Exists(index + "arc")) {
        return MakeHolder<TArchiveManager>(index, AOM_FILE, AT_MULTIPART);
    } else {
        return nullptr;
    }
} catch (...) {
    ERROR_LOG << "Cannot create ArchiveData: " << CurrentExceptionMessage() << Endl;
    return nullptr;
}
