#include "multipart_normalizer.h"

#include <kernel/multipart_archive/multipart.h>


TMultipartNormalizer::TMultipartNormalizer(const TRTYServerConfig& config, const TString& prefix, const NRTYArchive::TMultipartConfig& mpConfig)
    : NRTYServer::INormalizer(config)
    , Prefix(prefix)
    , MultipartConfig(mpConfig)
{}

const char* TMultipartNormalizer::Name() const {
    return "MultipartDataNormalizer";
}

bool TMultipartNormalizer::AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    return TArchiveOwner::Check(context.Dir.PathName() + '/' + Prefix);
}

void TMultipartNormalizer::Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    const TFsPath path(context.Dir.PathName() + '/' + Prefix);
    INFO_LOG << "Start " << Name() << " for " << path << Endl;
    NRTYServer::IIndexOwner::TGuardIndexModification g(context.Index);
    TArchiveOwner::Repair(path, MultipartConfig);
    INFO_LOG << "Finish " << Name() << " for " << path << Endl;
}
