#pragma once

#include <saas/rtyserver/indexer_core/normalizer.h>
#include <kernel/multipart_archive/config/config.h>

class TMultipartNormalizer: public NRTYServer::INormalizer {
public:
    TMultipartNormalizer(const TRTYServerConfig& config, const TString& prefix, const NRTYArchive::TMultipartConfig& mpConfig);

    virtual const char* Name() const;
    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;

private:
    const TString Prefix;
    const NRTYArchive::TMultipartConfig& MultipartConfig;
};
