#pragma once

#include <kernel/sent_lens/sent_lens_writer.h>

#include <util/system/mutex.h>
#include <util/folder/path.h>


class TSentenceLensProcessor;

class TRTYSentenceLengthWriter: public ISentenceLengthsWriter {
public:
    TRTYSentenceLengthWriter(const TFsPath& resultPrefix, const TFsPath& tempPrefix);
    void Close(const TVector<ui32>* remapTable, const std::atomic<bool> *rigidStopSignal);
    virtual void Add(ui32 docId, const ui8* begin, size_t size) override;
    virtual void LoadLength(ui32 docId, const TSentenceLensProcessor& proc);
    virtual void AddPacked(ui32 docId, const TSentenceLengths& lengthsPacked) override;

private:
    const TFsPath TempFile;
    const TFsPath FinalFile;
    THolder<TSentenceLengthsWriter> Writer;

    TMutex Mutex;
};
