#pragma once

#include "memory_manager.h"
#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/key_inv_processor/ki_maker.h>

class TKeysComponentConfig;
struct TDirConf;
class TRTYKIMaker;

class TKeysIndexBuilder: public NRTYServer::IIndexComponentBuilder {
protected:
    const TKeysComponentConfig* Config;
public:
    TKeysIndexBuilder(const TRTYServerConfig& rtyConfig, const TString& componentName);
    virtual void InitInteractions(const NRTYServer::IIndexBuildersStorage& /*storage*/) override {}
};

class TKeysIndexBuilderDisk: public TKeysIndexBuilder {
public:

    TKeysIndexBuilderDisk(const TPathName& dir, const NRTYServer::TIndexerConfig& config, const TString& componentName);
    virtual bool Start() override;
    virtual bool Stop() override;
    virtual void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    virtual void DoDiscard() override;
    virtual NRTYServer::IIndexComponentManager* GetManager() override;

private:
    TRTYKIMaker Maker;
};

class TKeysIndexBuilderMemory: public TKeysIndexBuilder {
public:
    TKeysIndexBuilderMemory(const TRTYServerConfig& rtyConfig, const TString& componentName);
    virtual bool Start() override;
    virtual bool Stop() override;
    virtual void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    virtual NRTYServer::IIndexComponentManager* GetManager() override;

private:
    TKeysIndexManagerMemory* Manager;
};

