#pragma once

#include "const.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>

class TKeysComponent: public NRTYServer::IIndexComponent {
private:
    TIndexFiles IndexFiles;
    const TRTYServerConfig& Config;
public:
    explicit TKeysComponent(const TRTYServerConfig& config);

    virtual TString GetName() const override;

    virtual bool DoMerge(const NRTYServer::TMergeContext& context) const override;
    virtual const TIndexFiles& GetIndexFiles() const override;
    virtual bool GetInfoChecker(NRTYServer::TInfoChecker& info) const override;

    virtual THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    virtual THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;

    virtual bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    virtual void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    virtual bool CheckConfig() const override;

    static bool IsUsedStatic(const TRTYServerConfig& config);
private:
    bool CheckKeyInv(const NRTYServer::TNormalizerContext& context) const;
    bool CheckBloom(const NRTYServer::TNormalizerContext& context) const;
    void FixKeyInv(const NRTYServer::TNormalizerContext& context) const;
    void FixBloom(const NRTYServer::TNormalizerContext& context) const;
    static TFactory::TRegistrator<TKeysComponent> Registrator;
};

