#pragma once
#include "manager.h"
#include <saas/rtyserver/key_inv_processor/ki_maker.h>
#include <library/cpp/bloom_filter/bloomfilter.h>

class TKeysIndexManagerDisk: public TKeysIndexManager {
private:
    const TString Path;
    THolder<TRTYKIReader> Reader;
    class TDiskIterator;
    TBloomFilterFaster ExistsKeys;

public:
    TKeysIndexManagerDisk(const TString& path, const TRTYServerConfig& config)
        : TKeysIndexManager(config)
        , Path(path)
    {
    }

    virtual bool DoOpen() override;
    virtual bool DoClose() override;
    virtual bool GetData(const TString& keyName, const TString& value, const IDocProcessor* filter, TSet<SUPERLONG>& result) const override;
    virtual bool HasKey(const TString& keyName, const TString& value) const override;
    virtual void GetKeyValues(const TString& keyName, TSet<TString>& result) const override;
    virtual TIterator::TPtr CreateIterator(const TString& keyName, const TString& value, const IDocProcessor* filter) const override;
};

