#include "parsed_entity.h"
#include "config.h"

#include <library/cpp/logger/global/global.h>
#include "const.h"

TKeysParsedEntity::TKeysParsedEntity(TConstructParams& params)
    : TParsedDocument::TParsedEntity(params)
{
}

TKeysComponentParser::TKeysComponentParser(const TRTYServerConfig& config)
{
    Config = config.ComponentsConfig.Get<TKeysComponentConfig>(NRTYServer::KeysComponentName);
}

void TKeysComponentParser::Parse(TParsingContext& context) const {
    auto entity = context.Result.GetComponentEntity<TKeysParsedEntity>(NRTYServer::KeysComponentName);
    CHECK_WITH_LOG(entity);

    for (ui32 i = 0; i < context.Document.AdditionalKeysSize(); ++i) {
        const auto prop = context.Document.GetAdditionalKeys(i);
        if (!prop.GetName()) {
            ythrow yexception() << "Incorrect name for special key: empty" << Endl;;
        }
        if (!prop.GetValue()) {
            ythrow yexception() << "Incorrect special key value for " << prop.GetName() << ": key's value is empty" << Endl;;
        }
        TDocSearchInfo dsi(prop.GetValue(), context.Document.GetKeyPrefix());
        entity->AddData(prop.GetName(), dsi, 0);
    }
}
