#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include "manager.h"

class TKeysComponentConfig;

class TKeysParsedEntity: public TParsedDocument::TParsedEntity {
private:
    THashMap<TString, TMap<TString, TSet<SUPERLONG>>> Data;
public:
    TKeysParsedEntity(TConstructParams& params);

    const THashMap<TString, TMap<TString, TSet<SUPERLONG>>>& GetData() const {
        return Data;
    }

    void AddData(const TString& name, const TDocSearchInfo& dsi, SUPERLONG position) {
        AddData(name, dsi.GetHash().Quote(), position);
    }

    void AddData(const TString& name, const TString& value, SUPERLONG position) {
        Data[name][value].insert(position);
    }
};

class TKeysComponentParser: public TComponentParser {
private:
    const TKeysComponentConfig* Config;

public:
    explicit TKeysComponentParser(const TRTYServerConfig& config);
    virtual void Parse(TParsingContext& context) const;
};
