#pragma once

#include <saas/rtyserver/model/builder.h>

namespace NOxygen {
    class TOxygenOptions;
}

namespace NRTYServer {
    using TStaticFilesConfig = NOxygen::TOxygenOptions;

    struct TStaticFilesBuilder : IIndexComponentBuilder {

        TStaticFilesBuilder(const TString& componentName, const TStaticFilesConfig&);

        bool Start() final;
        bool Stop() final;

        void InitInteractions(const IIndexBuildersStorage&) final;

        void Index(int threadID, const TParsedDocument&, const ui32 docId) final;
        NRTYServer::IIndexComponentManager* GetManager() final;
        bool DoClose(const TBuilderCloseContext&) final;

    private:
        const TStaticFilesConfig& Config;
    };

    void BuildAndReplaceStaticFiles(const TStaticFilesConfig& config, const TString& outputDirectory, TStringBuf reason);
    void RepairStaticFiles(const TStaticFilesConfig& config, const TString& outputDirectory, TStringBuf reason);
}
