#pragma once

#include <saas/rtyserver/components/generator/component.h>
#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>

struct TRTYServerConfig;

namespace NRTYServer {
    struct TStaticFilesComponent : IIndexComponent {
        explicit TStaticFilesComponent(const TRTYServerConfig& config);

        TString GetName() const final;
        bool IsCommonSearch() const final;
        TPriorityInfo GetPriority() const final;

        THolder<IIndexComponentBuilder> CreateBuilder(const TBuilderConstructionContext& context) const final;
        THolder<IIndexComponentManager> CreateManager(const TManagerConstructionContext& context) const final;
        IComponentParser::TPtr BuildParser() const final;
        IParsedEntity::TPtr BuildParsedEntity(IParsedEntity::TConstructParams& params) const final;

        bool DoMerge(const TMergeContext& context) const final;
        bool DoAllRight(const TNormalizerContext& context) const final;
        void CheckAndFix(const TNormalizerContext& context) const final;
        bool CheckAlways() const final;
        const IIndexComponent::TIndexFiles& GetIndexFiles() const final;

    private:
        const TRTYServerConfig& Config;
        TIndexFiles IndexFiles;
    };
}
