#pragma once

#include "const.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/components/generator/component.h>

#include <util/system/file.h>
#include "factors.h"

class TSuggestIndexComponent: public TBaseIndexComponent {
public:
    typedef TSet<TString> TNecessaryTuples;
protected:
    bool DoCheckMeta(const NRTYServer::TIndexMetadata& metaData) const override;
    bool DoMergeMeta(const NRTYServer::TMergeContext& context) const override;
    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;

public:
    explicit TSuggestIndexComponent(const TRTYServerConfig& config);

    bool CheckAlways() const override {
        return true;
    }

    bool IsCommonSearch() const override {
        return false;
    }

    THolder<TPruningConfig::ICalcer> CreatePruningCalcer(const NRTYServer::IIndexManagersStorage* /*managers*/) const override {
        return {};
    }

    TString GetName() const override {
        return SUGGEST_COMPONENT_NAME;
    }

    bool DoMerge(const NRTYServer::TMergeContext& context) const override;

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;

    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    bool CheckConfig() const override;
    bool IsEmptyIndex(const TString& path) const override;
    bool IsFinalIndex(const TString& path) const override;
    bool HasIndexFiles(const TString& path) const override;
private:
    static TFactory::TRegistrator<TSuggestIndexComponent> Registrator;
    NRTYServer::NSuggest::TFactors FactorsDescription;
};

