#include "config.h"

#include <library/cpp/yconf/conf.h>

#include <util/string/join.h>
#include <util/string/split.h>

bool TSuggestComponentConfig::DoCheck() const {
    return true;
}

void TSuggestComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
    ZonesWeightsFileInfo = componentSection.GetDirectives().Value<TString>("ZonesWeightsFileInfo", nullptr);
    ZonesInfo.Deserialize(ZonesWeightsFileInfo);
    CHECK_WITH_LOG(componentSection.GetDirectives().contains("ShardMin"));
    CHECK_WITH_LOG(componentSection.GetDirectives().contains("ShardMax"));
    Shards.SetMin(componentSection.GetDirectives().Value<NSearchMapParser::TShardIndex>("ShardMin", 0));
    Shards.SetMax(componentSection.GetDirectives().Value<NSearchMapParser::TShardIndex>("ShardMax", NSearchMapParser::SearchMapShards));
    ClearUnusefulData = componentSection.GetDirectives().Value<bool>("ClearUnusefulData", false);
    WordsCountToSave = componentSection.GetDirectives().Value<ui32>("WordsCountToSave", WordsCountToSave);
    WordsCountToReject = componentSection.GetDirectives().Value<ui32>("WordsCountToReject", WordsCountToReject);
    MaxDocumentsPortion = componentSection.GetDirectives().Value<ui32>("MaxDocumentsPortion", MaxDocumentsPortion);
    TString dictionaries = componentSection.GetDirectives().Value<TString>("FilterDictionaries", "");
    FilterDictionaries = SplitString(dictionaries, ";");
    AllowedSpecSimbols = componentSection.GetDirectives().Value<TString>("AllowedSpecSimbols", AllowedSpecSimbols);
    SaveOriginalText = componentSection.GetDirectives().Value<bool>("SaveOriginalText", false);
    MaxWordLength = componentSection.GetDirectives().Value<ui32>("MaxWordLength", MaxWordLength);
    UseEncodingFromPage = componentSection.GetDirectives().Value<bool>("UseEncodingFromPage", false);
    DefaultPruneCount = componentSection.GetDirectives().Value<ui32>("DefaultPruneCount", DefaultPruneCount);
    for (auto path : FilterDictionaries) {
        if (!TFsPath(path).Exists()) {
            ythrow yexception() << "Dictionary file not found: " << path;
        }
    }
    TString attributes = componentSection.GetDirectives().Value<TString>("AttributesBlacklist", "");
    StringSplitter(attributes).Split(';').SkipEmpty().Collect(&AttributesBlacklist);
}

void TSuggestComponentConfig::DoToString(IOutputStream& so) const {
    so << "ZonesWeightsFileInfo : " << ZonesWeightsFileInfo << Endl;
    so << "ShardMin : " << Shards.GetMin() << Endl;
    so << "ShardMax : " << Shards.GetMax() << Endl;
    so << "WordsCountToReject : " << WordsCountToReject << Endl;
    so << "MaxDocumentsPortion : " << MaxDocumentsPortion << Endl;
    so << "WordsCountToSave : " << WordsCountToSave << Endl;
    so << "ClearUnusefulData : " << ClearUnusefulData << Endl;
    so << "FilterDictionaries : " << JoinStrings(FilterDictionaries, ";") << Endl;
    so << "AllowedSpecSimbols : " << AllowedSpecSimbols << Endl;
    so << "SaveOriginalText : " << SaveOriginalText << Endl;
    so << "MaxWordLength : " << MaxWordLength << Endl;
    so << "UseEncodingFromPage : " << UseEncodingFromPage << Endl;
    so << "DefaultPruneCount : " << DefaultPruneCount << Endl;
    so << "AttributesBlacklist : " << JoinRange(";", AttributesBlacklist.cbegin(), AttributesBlacklist.cend()) << Endl;
}

const TSuggestZonesInfo& TSuggestComponentConfig::GetSuggestZonesInfo() const {
    return ZonesInfo;
}
