#pragma once

#include <saas/rtyserver/factors/factor.h>

namespace NRTYServer {

namespace NSuggest {
    class TFactors: public IRTYStaticFactors {
    private:
        TVector<NRTYFactors::TSimpleFactorDescription> Factors;
    public:
        TFactors() {
            Factors.push_back(NRTYFactors::TSimpleFactorDescription("weight", 0, 32, TBitsReader::ftInt));
            Factors.push_back(NRTYFactors::TSimpleFactorDescription("count", 0, 32, TBitsReader::ftInt));
            Factors.push_back(NRTYFactors::TSimpleFactorDescription("words", 0, 32, TBitsReader::ftInt));
        }

        virtual ui32 GetStaticFactorsCount() const {
            return Factors.size();
        }

        virtual const NRTYFactors::TSimpleFactorDescription& GetFactor(ui32 index) const {
            CHECK_WITH_LOG(index < Factors.size());
            return Factors[index];
        }
    };

}
}
