#include "parser_helpers.h"

namespace NSaasHtmlParser {
    TString FilterHtmlText(const TString& text, TSuggestComponentConfig& config) {
        const auto& zonesInfo = config.GetSuggestZonesInfo();
        const TDictFilter dictFilter(config.GetFilterDictionaries());
        THtmlParserResult parserResult(zonesInfo, &config, dictFilter);
        NHtml5::ParseHtml(TStringBuf(text), &parserResult);

        TString textFiltered;
        for (auto&& it : parserResult.GetSentences()) {
            textFiltered += "<" + it.first + ">";
            for (auto&& entry : it.second) {
                const TString& sentence = WideToUTF8(entry.Sentence);
                textFiltered += sentence + ". ";
            }
            textFiltered += "</" + it.first + ">";
        }
        return textFiltered;
    }
}
