#pragma once

#include "manager.h"
#include "factors_calcer.h"
#include <ysite/yandex/posfilter/hits_loader.h>

class TSuggestSearcher {
public:
    TSuggestSearcher(const TSuggestIndexManager& manager, const TCgiParameters& cgi, ICustomReportBuilder& reportBuilder);
    ~TSuggestSearcher();
    ERTYSearchResult Search();

private:
    struct TFoundSuggest {
        TFoundSuggest(const TString& suggest, ui32 factorsCount)
            : Suggest(suggest)
            , Factors(factorsCount)
        {}

        TString Suggest;
        TFactorStorage Factors;
        float Relevance = 0;
        inline bool operator < (const TFoundSuggest& other) const {
            return Relevance > other.Relevance; // it is not error
        }
    };

    typedef TSuggestFactorsCalcer::THits THits;
    typedef TVector<TFoundSuggest> TFound;
    class THitsStorage;

private:
    void ProcessLeafs();
    ERTYSearchResult Report();
    TString GetJsonFactors(const TFoundSuggest& record) const;
    void AdjustTopAndArgs();
    void AddFound(ui64 erfAddress, const THits& hits);
    void PrepareSearch();
    void ParseRequest();
    void ParseKpses();
    void ParseRelev();
    void ParsePron();

private:
    const TSuggestIndexManager& Manager;
    const TCgiParameters& Cgi;
    ICustomReportBuilder& ReportBuilder;
    THitsLoader HitsLoader;
    TTopAndArgs TopAndArgs;
    ui32 Numdoc;
    ui32 PruneCount;
    const NRTYFactors::TRankModelHolder* RankModel;
    TFound Found;
    ui32 FactorsCount;
    TVector<TUtf16String> NormalizedRequest;
    bool Wildcard;
    TSuggestFactorsCalcer SuggestFactorsCalcer;
    TVector<ui64> Kpses;
    bool GtaJsonFactors;
    bool FsgtaJsonFactors;
};
