#include "builder.h"
#include "const.h"
#include "config.h"

#include <library/cpp/logger/global/global.h>
#include "parsed_entity.h"

TTemplateIndexBuilder::TTemplateIndexBuilder(const TDirConf& /*dirConfig*/, const TRTYServerConfig& rtyConfig, const TString& componentName)
    : NRTYServer::IIndexComponentBuilder(componentName)
    , Config(rtyConfig.ComponentsConfig.Get<TTemplateComponentConfig>(NRTYServer::TemplateComponentName))
{
    CHECK_WITH_LOG(Config);
}

bool TTemplateIndexBuilder::DoClose(const NRTYServer::TBuilderCloseContext& /*context*/) {
    return true;
}

void TTemplateIndexBuilder::Index(int /*threadID*/, const TParsedDocument& /*document*/, const ui32 /*docId*/) {
}
