#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>

class TTemplateComponentConfig;
struct TDirConf;
struct TRTYServerConfig;

class TTemplateIndexBuilder: public NRTYServer::IIndexComponentBuilder {
private:
    const TTemplateComponentConfig* Config;
public:
    TTemplateIndexBuilder(const TDirConf& dirConfig, const TRTYServerConfig& rtyConfig, const TString& componentName);

    virtual NRTYServer::IIndexComponentManager* GetManager() override {
        return nullptr;
    }
    virtual void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;

    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;

    virtual void InitInteractions(const NRTYServer::IIndexBuildersStorage& /*storage*/) override {}

    virtual bool Start() override {
        return true;
    }
    virtual bool Stop() override {
        return true;
    }
};
