#include "component.h"
#include "config.h"
#include "builder.h"
#include "manager.h"
#include "parsed_entity.h"
#include "const.h"

#include <saas/rtyserver/config/common_indexers_config.h>
#include <saas/rtyserver/config/indexer_config.h>

TTemplateComponent::TTemplateComponent(const TRTYServerConfig& config)
    : IIndexComponent(
            config.IndexGenerator == NRTYServer::TemplateComponentName ||
            config.ComponentsSet.contains(NRTYServer::TemplateComponentName))
    , Config(config)
    , ComponentConfig(Config.ComponentsConfig.Get<TTemplateComponentConfig>(NRTYServer::TemplateComponentName))
{
}

const TTemplateComponent::TIndexFiles& TTemplateComponent::GetIndexFiles() const {
    return IndexFiles;
}

THolder<NRTYServer::IIndexComponentBuilder> TTemplateComponent::CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const {
    if (context.Config.GetType() == "memory") {
        return nullptr;
    }

    return MakeHolder<TTemplateIndexBuilder>(context.DirConfig, context.Config.Common.Owner, GetName());
}

THolder<NRTYServer::IIndexComponentManager> TTemplateComponent::CreateManager(const NRTYServer::TManagerConstructionContext& context) const {
    switch (context.IndexType) {
        case IIndexController::FINAL:
        case IIndexController::PREPARED:
        case IIndexController::DISK:
            return MakeHolder<TTemplateIndexManager>(context, NRTYServer::TemplateComponentName);
        case IIndexController::MEMORY:
            return nullptr;
        default:
            FAIL_LOG("Incorrect index type");
    }
}

bool TTemplateComponent::DoMerge(const NRTYServer::TMergeContext& /*context*/) const {
    return false;
}

NRTYServer::IComponentParser::TPtr TTemplateComponent::BuildParser() const {
    return new TTemplateComponentParser(Config);
}

NRTYServer::IParsedEntity::TPtr TTemplateComponent::BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const {
    return new TTemplateParsedEntity(params);
}

bool TTemplateComponent::DoAllRight(const NRTYServer::TNormalizerContext& /*context*/) const {
    return true;
}

bool TTemplateComponent::CheckConfig() const {
    return true;
}

void TTemplateComponent::CheckAndFix(const NRTYServer::TNormalizerContext& /*context*/) const {
}
