#pragma once

#include "const.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include "config.h"

class TTemplateComponent: public NRTYServer::IIndexComponent {
private:
    TIndexFiles IndexFiles;
    const TRTYServerConfig& Config;
    const TTemplateComponentConfig* ComponentConfig = nullptr;

public:
    explicit TTemplateComponent(const TRTYServerConfig& config);

    const TTemplateComponentConfig* GetComponentConfig() const {
        return ComponentConfig;
    }

    virtual TString GetName() const override {
        return NRTYServer::TemplateComponentName;
    }

    virtual bool DoMerge(const NRTYServer::TMergeContext& context) const override;
    virtual const TIndexFiles& GetIndexFiles() const override;

    virtual THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    virtual THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    virtual NRTYServer::IComponentParser::TPtr BuildParser() const override;
    virtual NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;

    virtual bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    virtual void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    virtual bool CheckConfig() const override;
private:
    static TFactory::TRegistrator<TTemplateComponent> Registrator;
};

