#include "const.h"
#include "config.h"
#include "manager.h"

#include <saas/rtyserver/config/common_indexers_config.h>
#include <saas/rtyserver/config/indexer_config.h>

ui32 TTemplateIndexManager::GetDocumentsCount() const {
    return Max<ui32>();
}

ui32 TTemplateIndexManager::RemoveDocids(const TVector<ui32>& /*docids*/) {
    return 0;
}

TTemplateIndexManager::TTemplateIndexManager(const NRTYServer::TManagerConstructionContext& context, const TString& componentName)
    : NRTYServer::IIndexComponentManager(componentName)
    , Path(context.Dir.PathName())
{
    Config = context.Config.Common.Owner.ComponentsConfig.Get<TTemplateComponentConfig>(ComponentName);
    CHECK_WITH_LOG(Config);
}

TTemplateIndexManager::~TTemplateIndexManager() {
}

bool TTemplateIndexManager::DoOpen() {
    return true;
}

bool TTemplateIndexManager::DoClose() {
    return true;
}

void TTemplateIndexManager::InitInteractions(const NRTYServer::IIndexManagersStorage& /*storage*/) {
}

