#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>

class TTemplateComponentConfig;

class TTemplateIndexManager: public NRTYServer::IIndexComponentManager {
private:
    const TTemplateComponentConfig* Config;
    TFsPath Path;
public:
    TTemplateIndexManager(const NRTYServer::TManagerConstructionContext& context, const TString& componentName);
    ~TTemplateIndexManager();

    virtual void InitInteractions(const NRTYServer::IIndexManagersStorage& storage) override;
    virtual ui32 RemoveDocids(const TVector<ui32>& docids) override;
    virtual ui32 GetDocumentsCount() const override;

    virtual bool GetDocInfo(const ui32 /* docId */, NJson::TJsonValue& /* result */) const override {
        return false;
    }

    virtual bool DoOpen() override;
    virtual bool DoClose() override;
};
