#pragma once

#include <kernel/saas_trie/disk_io.h>

#include <saas/rtyserver/model/builder.h>

#include <util/generic/ptr.h>

struct TRTYServerConfig;
class TRTYFullArchiveBuilder;

class IDocSearchInfoIterator;

namespace NSaasTrie {
    struct ITrieStorage;
    struct ITrieStorageWriter;
}

namespace NRTYServer {
    class TTrieComponentConfig;

    class TTrieIndexBuilder: public IIndexComponentBuilder {
    public:
        TTrieIndexBuilder(const TString& componentName);

        bool Start() override;
        bool Stop() override;
    };

    class TTrieIndexBuilderMemory : public TTrieIndexBuilder {
    public:
        explicit TTrieIndexBuilderMemory(const TString& componentName);
        void InitInteractions(const IIndexBuildersStorage&) override;

        void Index(int threadID, const TParsedDocument&, const ui32 docId) override;
        NRTYServer::IIndexComponentManager* GetManager() override;
        bool DoClose(const TBuilderCloseContext&) override;
        void DoDiscard() override;

    private:
        TAtomicSharedPtr<NSaasTrie::ITrieStorage> Storage;
    };

    class TTrieIndexBuilderDisk : public TTrieIndexBuilder {
    public:
        TTrieIndexBuilderDisk(const TString& componentName, TString path);
        void InitInteractions(const IIndexBuildersStorage&) override;

        void Index(int threadID, const TParsedDocument&, const ui32 docId) override;
        NRTYServer::IIndexComponentManager* GetManager() override;
        bool DoClose(const TBuilderCloseContext&) override;
        void DoDiscard() override;

    private:
        TRTYFullArchiveBuilder* FullArcBuilder = nullptr;
        TString Path;
        NSaasTrie::TDiskIO Disk;
    };

    void BuildTrieFromDocIterator(const TString& path, const NSaasTrie::IDiskIO& disk, IDocSearchInfoIterator&);
}
