#pragma once

#include <kernel/saas_trie/disk_io.h>

#include <saas/rtyserver/components/generator/component.h>
#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>

struct TRTYServerConfig;

namespace NRTYServer {
    class TTrieComponentConfig;
    struct ITrieMultiSegmentSearcher;

    class TTrieComponent: public IIndexComponent {
    public:
        explicit TTrieComponent(const TRTYServerConfig& config);

        TString GetName() const override;
        bool IsCommonSearch() const override;
        IIndexComponent::TPriorityInfo GetPriority() const override;

        THolder<IIndexComponentBuilder> CreateBuilder(const TBuilderConstructionContext& context) const override;
        THolder<IIndexComponentManager> CreateManager(const TManagerConstructionContext& context) const override;
        IComponentParser::TPtr BuildParser() const override;
        IParsedEntity::TPtr BuildParsedEntity(IParsedEntity::TConstructParams& params) const override;

        bool DoMerge(const TMergeContext& context) const override;
        bool DoAllRight(const TNormalizerContext& context) const override;
        void CheckAndFix(const TNormalizerContext& context) const override;
        const IIndexComponent::TIndexFiles& GetIndexFiles() const override;

        void SearchCustom(const TVector<IIndexController::TPtr>& controllers,
                          ICustomReportBuilder& report,
                          const TRTYSearchRequestContext& context) const override;

    private:
        const TRTYServerConfig& Config;
        const TTrieComponentConfig& TrieConfig;
        TIndexFiles IndexFiles;
        NSaasTrie::TDiskIO Disk;
        THolder<ITrieMultiSegmentSearcher> MultiSearcher;
    };
}
