#include "config.h"

#include <library/cpp/yconf/conf.h>

#include <util/folder/path.h>

namespace NRTYServer {
    bool TTrieComponentConfig::DoCheck() const {
        return true;
    }

    const TString& TTrieComponentConfig::GetUniqueDimension() const {
        return UniqueDimension;
    }

    ui32 TTrieComponentConfig::GetSearchThreadCount() const {
        return SearchThreadCount;
    }

    bool TTrieComponentConfig::NeedToSortComplexKey() const {
        return SortComplexKey;
    }

    const TString& TTrieComponentConfig::GetPropertyPrefix() const {
        return PropertyPrefix;
    }

    void TTrieComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
        UniqueDimension = componentSection.GetDirectives().Value<TString>("UniqueDimension", TString{});
        SearchThreadCount = componentSection.GetDirectives().Value<ui32>("SearchThreads", 0);
        SortComplexKey = componentSection.GetDirectives().Value<bool>("SortComplexKey", true);
        PropertyPrefix = componentSection.GetDirectives().Value<TString>("PropertyPrefix", TString{});
    }

    void TTrieComponentConfig::DoToString(IOutputStream& out) const {
        out << "UniqueDimension : " << UniqueDimension << Endl;
        out << "SearchThreads : " << SearchThreadCount << Endl;
        out << "SortComplexKey : " << SortComplexKey << Endl;
        out << "PropertyPrefix : " << PropertyPrefix << Endl;
    }

    TString GetTrieIndexPath(const TString& indexPath) {
        return TFsPath(indexPath) / TrieIndexName;
    }
}
