#pragma once

#include <kernel/saas_trie/config.h>

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/common/doc_search_info.h>
#include <saas/rtyserver/config/config.h>

namespace NRTYServer {
    extern const TString TrieComponentName;
    extern const TString TrieIndexName;

    class TTrieComponentConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
    public:
        const TString& GetUniqueDimension() const;
        ui32 GetSearchThreadCount() const;
        bool NeedToSortComplexKey() const;
        const TString& GetPropertyPrefix() const;

    protected:
        bool DoCheck() const override;
        void DoInit(const TYandexConfig::Section& componentSection) override;
        void DoToString(IOutputStream& so) const override;

    private:
        TString UniqueDimension;
        TString PropertyPrefix;
        ui32 SearchThreadCount = 0;
        bool SortComplexKey = true;
    };

    TString GetTrieIndexPath(const TString& indexPath);

    inline TString GetTrieKey(const TDocSearchInfo& info) {
        return NSaasTrie::GetTrieKey(info.GetKeyPrefix(), info.GetUrl());
    }
}
