#pragma once

#include <kernel/saas_trie/abstract_trie.h>

#include <saas/rtyserver/model/manager.h>

#include <util/generic/ptr.h>

class IFAManager;
struct TRTYServerConfig;

namespace NRTYServer {
    struct TTrieSearchRequest;

    class TTrieIndexManager: public NRTYServer::IIndexComponentManager {
    public:
        explicit TTrieIndexManager(TAtomicSharedPtr<NSaasTrie::ITrieStorage>);

        bool DoOpen() override;
        bool DoClose() override;

        ui32 GetDocumentsCount() const override;
        void InitInteractions(const IIndexManagersStorage& storage) override;

        ERTYSearchResult DoSearch(const TRTYSearchRequestContext& context,
                                  ICustomReportBuilder& reportBuilder,
                                  const IIndexController& controller) const override;

        ui32 DoSearch(const TTrieSearchRequest& request,
                      const IFAManager& fullArc,
                      const TCgiParameters& parameters,
                      ISimpleReportBuilder& reportBuilder) const;

        ui32 RemoveDocids(const TVector<ui32>& docIds) override;

    private:
        TAtomicSharedPtr<NSaasTrie::ITrieStorage> Storage;
        const IIndexComponentManager* FullArc = nullptr;
    };
}
