#pragma once

#include <search/idl/meta.pb.h>

#include <util/generic/hash.h>

namespace NRTYServer {
    namespace NTrie {
        struct TDocumentWrapper {
            TDocumentWrapper(NMetaProtocol::TDocument& document, char delimiter, size_t prefixLevel, const THashMap<TString, ui32>& suffixMap);

            TStringBuf GetPrefix() const;
            ui32 GetSuffix() const;
            const NMetaProtocol::TDocument& GetDocument() const;
            NMetaProtocol::TDocument& GetDocument();
            void SetDocument(NMetaProtocol::TDocument&);

            bool operator<(const TDocumentWrapper& rhs) const;

        private:
            NMetaProtocol::TDocument* Document = nullptr;
            ui32 PrefixSize = 0;
            ui32 Suffix = 0;
        };
    }
}
