#pragma once

#include <saas/library/report_builder/abstract.h>

#include "document_wrapper.h"

#include <util/generic/deque.h>
#include <util/generic/hash.h>
#include <util/generic/list.h>

namespace NRTYServer {
    namespace NTrie {
        struct TReportFilter : ISimpleReportBuilder {
            TReportFilter(ISimpleReportBuilder& output, char prefixDelimiter, size_t prefixLevel, THashMap<TString, ui32> suffixMap);

            void AddDocument(NMetaProtocol::TDocument& doc) override final;
            void AddDocuments(TList<NMetaProtocol::TDocument> docs) override final;

            void Finalize(TStringBuf attrPrefix);

        private:
            ISimpleReportBuilder& Output;
            TList<NMetaProtocol::TDocument> Documents;
            TDeque<TDocumentWrapper> Wrappers;

            const THashMap<TString, ui32> SuffixMap;
            const size_t PrefixLevel;
            const char PrefixDelimiter;
        };

        void FilterDocuments(TDeque<TDocumentWrapper>& docs, ISimpleReportBuilder& output, TStringBuf attrPrefix);
    }
}

