#pragma once

#include <saas/rtyserver/model/index.h>

namespace NRTYServer {
    struct TTrieSearchRequest;

    struct ITrieMultiSegmentSearcher {
        virtual ~ITrieMultiSegmentSearcher() = default;
        virtual void DoSearch(TTrieSearchRequest& searchRequest,
                            const TCgiParameters& cgiParams,
                            const TVector<IIndexController::TPtr>& controllers) = 0;
    };

    THolder<ITrieMultiSegmentSearcher> CreateTrieSearcher(TString indexGenerator, ui32 nThreads);
}
