#pragma once

#include <saas/rtyserver/components/trie/qd_report_filter/report_filter.h>

#include <kernel/saas_trie/trie_complex_key_iterator.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <library/cpp/cgiparam/cgiparam.h>
#include <util/system/types.h>

namespace NRTYServer {
    struct TTrieSearchRequest {
        TTrieSearchRequest(const TCgiParameters&, const TMap<TString, TString>* trieParams, bool sortKeys,
                           const TString& uniqueDimension, TString propertyPrefix, ISimpleReportBuilder&);

        bool IsValid() const;
        THolder<NSaasTrie::ITrieStorageIterator> CreateIterator(const NSaasTrie::ITrieStorageReader&) const;
        ui32 GetMaxDocs() const;
        ui32 DecreaseMaxDocs(ui32 foundCount);

        bool NextIterator();
        ISimpleReportBuilder& GetReport();

    private:
        ISimpleReportBuilder& ReportBuilder;
        TString PropertyPrefix;

        TVector<TString> Texts;
        TVector<NSaasTrie::TComplexKeyPreprocessed> ComplexKeys;
        TVector<NSaasTrie::TComplexKeyPreprocessed> ComplexKeysUnique;

        TMaybe<NTrie::TReportFilter> ReportFilter;
        ui32 IteratorIndex = Max<ui32>();
        ui32 IteratorCount = 0;
        ui32 UniqueOffset = 0;

        ui32 MaxDocs = 150;
    };
}
