#pragma once

#include "memory_manager.h"
#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/key_inv_processor/ki_maker.h>

class TTrigramComponentConfig;
struct TDirConf;
class TRTYKIMaker;

class TTrigramIndexBuilder: public NRTYServer::IIndexComponentBuilder {
protected:
    const TTrigramComponentConfig* Config;

public:
    TTrigramIndexBuilder(const TRTYServerConfig& rtyConfig, const TString& componentName);
    virtual void InitInteractions(const NRTYServer::IIndexBuildersStorage& /*storage*/) override {
    }
};

class TTrigramIndexBuilderDisk: public TTrigramIndexBuilder {
public:
    TTrigramIndexBuilderDisk(const TPathName& dir, const NRTYServer::TIndexerConfig& config, const TString& componentName);
    virtual bool Start() override;
    virtual bool Stop() override;
    virtual void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    virtual void DoDiscard() override;
    virtual NRTYServer::IIndexComponentManager* GetManager() override;

private:
    TRTYKIMaker Maker;
};

class TTrigramIndexBuilderMemory: public TTrigramIndexBuilder {
public:
    TTrigramIndexBuilderMemory(const TRTYServerConfig& rtyConfig, const TString& componentName);
    virtual bool Start() override;
    virtual bool Stop() override;
    virtual void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    virtual NRTYServer::IIndexComponentManager* GetManager() override;

private:
    TTrigramIndexManagerMemory* Manager;
};
