#pragma once

#include "manager.h"
#include <saas/rtyserver/key_inv_processor/ki_maker.h>
#include <library/cpp/bloom_filter/bloomfilter.h>

class TTrigramIndexManagerDisk: public TTrigramIndexManager {
private:
    const TString Path;
    THolder<TRTYKIReader> Reader;
    class TDiskIterator;

public:
    TTrigramIndexManagerDisk(const TString& path, const TRTYServerConfig& config)
        : TTrigramIndexManager(config)
        , Path(path)
    {
    }

    virtual bool DoOpen() override;
    virtual bool DoClose() override;
    virtual bool GetData(const TString& keyName, const TString& value, const IDocProcessor* filter, TSet<SUPERLONG>& result) const override;
    virtual TIterator::TPtr CreateIterator(const TString& keyName, const TString& value, const IDocProcessor* filter) const override;
};
