#pragma once

#include "manager.h"

class TIntersectIterator: public TAtomicRefCount<TIntersectIterator> {
public:
    using TPtr = TIntrusivePtr<TIntersectIterator>;
    TIntersectIterator(const TVector<TTrigramIndexManager::TIterator::TPtr>& iterators);
    virtual ~TIntersectIterator() {
    }
    virtual bool Valid() const;
    virtual void Next();
    virtual SUPERLONG GetPosition() const;

private:
    SUPERLONG CurrentMax;
    size_t InvalidIteratorsCount;
    TVector<TTrigramIndexManager::TIterator::TPtr> Iterators;
};
