#pragma once

#include "manager.h"

#include <saas/rtyserver/indexer_core/document_parser.h>
#include <saas/rtyserver/indexer_core/parsed_document.h>

class TTrigramComponentConfig;

class TTrigramParsedEntity: public TParsedDocument::TParsedEntity {
private:
    THashMap<TString, TMap<TString, TSet<SUPERLONG>>> Data;

public:
    TTrigramParsedEntity(TConstructParams& params);

    const THashMap<TString, TMap<TString, TSet<SUPERLONG>>>& GetData() const {
        return Data;
    }

    void AddData(const TString& name, const TDocSearchInfo& dsi, SUPERLONG position) {
        AddData(name, dsi.GetHash().Quote(), position);
    }

    void AddData(const TString& name, const TString& value, SUPERLONG position) {
        Data[name][value].insert(position);
    }
};

class TTrigramComponentParser: public TComponentParser {
private:
    const TTrigramComponentConfig* Config;

public:
    explicit TTrigramComponentParser(const TRTYServerConfig& config);
    virtual void Parse(TParsingContext& context) const;
};
