#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>
class TUrlToDocIdConfig;


class TUrlToDocIdBuilder: public NRTYServer::IIndexComponentBuilder {
public: // NRTYServer::IIndexComponentBuilder
        TUrlToDocIdBuilder(const TString& fileName, const TString& componentName, const TUrlToDocIdConfig& config)
        : NRTYServer::IIndexComponentBuilder(componentName), File(fileName), ComponentConfig(config)
    {

    }
    bool Start() override { return true; }
    bool Stop() override { return true; }
    void InitInteractions(const NRTYServer::IIndexBuildersStorage& /*storage*/) override {}
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    void Index(int threadId, const TParsedDocument& document, const ui32 docId) override;
    NRTYServer::IIndexComponentManager *GetManager() override;

protected:
    TMutex PoolLock;
    TString File;
    const TUrlToDocIdConfig& ComponentConfig;
    ui32 CurrentVersion;
};
