#pragma once


#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include <saas/rtyserver/components/generator/builders_storage.h>
#include <saas/rtyserver/model/storages.h>
#include "builder.h"
#include "manager.h"
#include "config.h"
#include <saas/library/hash_to_docid/hash_to_docid.h>
#include <saas/library/hash_to_docid/doc_hash_iterator.h>

namespace {
    struct THashStorageAdapter : NSaas::IDocHashStorage {
        struct TDocInfo2DocHashIterator : NSaas::IDocHashIterator {
            THolder<NRTYServer::IDocSearchInfoIterator> BaseIterator;

            TDocInfo2DocHashIterator(THolder<NRTYServer::IDocSearchInfoIterator> &&base):
                BaseIterator(std::move(base)) {
            }
            bool IsValid() const override {
                return BaseIterator && BaseIterator->IsValid();
            }

            void Next() override {
                BaseIterator->Next();
            }
            std::pair<NSaas::TDocHash, ui32> GetHashWithId() const override {
                return BaseIterator->GetHashWithId();
            }
        };

        const NRTYServer::IIndexManagersStorage &Storage;

        THashStorageAdapter(const NRTYServer::IIndexManagersStorage &storage):
            Storage(storage) {
        }
        ui64 GetEstimatedSize() const override {
            return Storage.GetDocumentsCount();
        }
        THolder<NSaas::IDocHashIterator> CreateDocHashIterator() const override {
            return THolder(new TDocInfo2DocHashIterator(Storage.GetDocSearchInfoIterator()));
        }
    };
}


class TUrlToDocIdComponent: public NRTYServer::IIndexComponent {

public:
    explicit TUrlToDocIdComponent(const TRTYServerConfig& config);

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;

    bool CheckAlways() const override {
        return true;
    }

    TString GetName() const override {
        return URL2DOCID_COMPONENT_NAME;
    }

    bool DoMerge(const NRTYServer::TMergeContext& /*rtyContext*/) const override {
        return true;
    }

    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    const TIndexFiles& GetIndexFiles() const override {
        return IndexFiles;
    }

private:
    bool CheckPath(const NRTYServer::TNormalizerContext& context) const;

    const TUrlToDocIdConfig &ComponentConfig;
    const TRTYServerConfig& Config;
    NSaas::THashToDocId HashToDocId;
    static TFactory::TRegistrator<TUrlToDocIdComponent> Registrator;
    TIndexFiles IndexFiles;
};
