#include "manager.h"
#include <saas/library/mapping/mapping.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>


bool TUrlToDocIdManager::IsOpen() const {
    return HashToDocId.IsOpen();
}

bool TUrlToDocIdManager::DoOpen() {
    return HashToDocId.Open(FileName);
}

bool TUrlToDocIdManager::DoClose() {
    HashToDocId.Close();
    return true;
}

TDocIdCandidate TUrlToDocIdManager::GetIdCandidateByDocInfo(const TDocSearchInfo& info) const {
    ui32 id = HashToDocId.GetIdByHash(info.GetHash());
    TDocIdCandidate result(info);
    result.SetDocId(id);
    result.SetVerified(IsDocCandidateAlwaysVerified());
    return result;
}

ui32 TUrlToDocIdManager::GetIdByDocInfo(const TDocSearchInfo& info) const {
    return HashToDocId.GetIdByHash(info.GetHash());
}

ui32 TUrlToDocIdManager::GetIdByHash(const NSaas::TDocHash& hash) const {
    return HashToDocId.GetIdByHash(hash);
}

ui32 TUrlToDocIdManager::GetDocumentsCount() const {
    return Max<ui32>();
}

bool TUrlToDocIdManager::IsDocCandidateAlwaysVerified() const {
    return true;
}

void TUrlToDocIdManager::InitInteractions(const NRTYServer::IIndexManagersStorage& storage) {
    FullArc = storage.GetManager<IIndexComponentManager>(FULL_ARCHIVE_COMPONENT_NAME);
    VERIFY_WITH_LOG(FullArc, "Can not find FULLARC manager");
}

bool TUrlToDocIdManager::GetDocInfo(const ui32 /*docId*/, NJson::TJsonValue& /*result*/) const {
    return false;
}

bool TUrlToDocIdManager::UpdateDoc(ui32 /*docId*/, const TParsedDocument::TPtr /*doc*/) {
    return false;
}

ui32 TUrlToDocIdManager::RemoveDocids(const TVector<ui32>& /*docids*/) {
    return 0;
};

ui32 TUrlToDocIdManager::MarkDocIdsForDeleteUnsafe(const TVector<ui32>& /*docids*/, ui32 /*marker*/) {
    return 0;
}

ERTYSearchResult TUrlToDocIdManager::DoSearch(const TRTYSearchRequestContext& /*context*/, ICustomReportBuilder& /*report
Builder*/, const IIndexController& /*controller*/) const {
    return SR_NOT_FOUND;
}
