#pragma once

#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/library/hash_to_docid/hash_to_docid.h>
#include "config.h"

class TUrlToDocIdManager :
            public IUrlToDocIdManager,
            public NRTYServer::IIndexComponentManager {
public:
    TUrlToDocIdManager(const TString &componentName):
                    IIndexComponentManager(componentName)
                    {}
    TUrlToDocIdManager(const TString &filename, const TString &componentName, const TUrlToDocIdConfig& config, const TThrottle::TOptions& writeOption):
                    IIndexComponentManager(componentName),
                    FileName(filename),
                    HashToDocId(config.GetUseGlobalMapping()),
                    ComponentConfig(config),
                    WriteOption(writeOption) {
    }
    bool IsOpen() const;
public: // IUrlToDocIdManager
    virtual TDocIdCandidate GetIdCandidateByDocInfo(const TDocSearchInfo& info) const override;
    virtual ui32 GetIdByDocInfo(const TDocSearchInfo& info) const override;
    virtual ui32 GetIdByHash(const NSaas::TDocHash& hash) const override;
    virtual bool IsDocCandidateAlwaysVerified() const override;

public: // NRTYServer::IIndexComponentManager
    virtual bool DoOpen() override;
    virtual bool DoClose() override;
    virtual ui32 GetDocumentsCount() const override;
    virtual void InitInteractions(const NRTYServer::IIndexManagersStorage& storage) override;
    virtual bool GetDocInfo(const ui32 docId, NJson::TJsonValue& result) const override;
    virtual bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) override;
    virtual ui32 RemoveDocids(const TVector<ui32>& docids) override;
    virtual ui32 MarkDocIdsForDeleteUnsafe(const TVector<ui32>& docids, ui32 marker) override;
    virtual ERTYSearchResult DoSearch(const TRTYSearchRequestContext& /*context*/, ICustomReportBuilder& /*reportBuilder*/, const IIndexController& /*controller*/) const override;

protected:
    TString FileName;
    NSaas::THashToDocId HashToDocId;
    TUrlToDocIdConfig ComponentConfig;
    const IIndexComponentManager* FullArc;
    TThrottle::TOptions WriteOption;
    static IUrlToDocIdManager::TRemapperFactory::TRegistrator<TUrlToDocIdManager> RemapperRegistrator;
};

