#pragma once

#include <saas/util/optional_allocator.h>

class TMakeupAllocatorsStorage {
public:
    TMakeupAllocatorsStorage();
    TMakeupAllocatorsStorage(bool usePools);

    inline TOptionalAllocator& GetSpansZonesAllocator() {
        return SpansZonesAllocator;
    }

    inline TOptionalAllocator& GetLengthZonesAllocator() {
        return LengthZonesAllocator;
    }

    inline TOptionalAllocator& GetSentsMakeupAllocator() {
        return SentsMakeupAllocator;
    }

    static TMakeupAllocatorsStorage& Default();

private:
    TOptionalAllocator SpansZonesAllocator;
    TOptionalAllocator LengthZonesAllocator;
    TOptionalAllocator SentsMakeupAllocator;

};
