#pragma once

#include "makeup_saver.h"
#include "read_write_makeup_manager.h"

#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/config/indexer_config.h>
#include <saas/rtyserver/indexer_core/indexer_core.h>
#include <saas/rtyserver/indexer_core/parsed_document.h>

#include <saas/rtyserver/merger/library/merger.h>

class TRTYMakeupBuilder: public IMakeupWritableStorageOwner, public NRTYServer::IIndexComponentBuilder {
protected:
    TReadWriteRTYMakeupManager* Manager;
    TVector<THolder<TMakeupSaver>> Savers;
    const TRTYServerConfig& Config;
    const NRTYServer::TIndexerConfig& IndexerConfig;
public:
    TRTYMakeupBuilder(ui32 countDocs, const NRTYServer::TIndexerConfig& config, bool useMemPool, bool isMem, const TString& componentName);

    void InitSavers();

    TMakeupSaver* GetSaver(int i) {
        VERIFY_WITH_LOG(i >= 0 && i < Savers.ysize(), "Incorrect saver index");
        return Savers[i].Get();
    }

public: // IMakeupWritableStorageOwner
    virtual IMakeupWritableStorage* GetMakeupStorage() override { return Manager; }

public: // NRTYServer::IIndexComponentBuilder
    virtual NRTYServer::IIndexComponentManager* GetManager() override { return Manager; }
    virtual void Index(int threadID, const TParsedDocument& document, const ui32 docId)  override;
    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& /* context */) override { return true; }
    virtual bool Start() override { return true; }
    virtual bool Stop() override { return true; }
    virtual void InitInteractions(const NRTYServer::IIndexBuildersStorage& storage) override;
};

class TRTYMemoryMakeupBuilder: public TRTYMakeupBuilder {
public:
    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    TRTYMemoryMakeupBuilder(ui32 countDocs, const TRTYServerConfig& config, const TString& componentName)
        : TRTYMakeupBuilder(countDocs, config.GetIndexerMemoryConfig(), false, true, componentName)
    {
    }
};

class TRTYDiskMakeupBuilder: public TRTYMakeupBuilder {
public:
    TRTYDiskMakeupBuilder(ui32 countDocs, const NRTYServer::TIndexerConfig& config, bool useMemPool, const TString& componentName)
        : TRTYMakeupBuilder(countDocs, config, useMemPool, false, componentName)
    {
    }
    virtual bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
};

typedef TAtomicSharedPtr<TRTYMakeupBuilder> TRTYMakeupBuilderPtr;
