#pragma once

#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/config/const.h>
#include <saas/rtyserver/factors/factors_config.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/merger/library/file_block_merger.h>

#define MAKEUP_COMPONENT_NAME "MAKEUP"

class TRTYMakeupIndexComponent : public NRTYServer::IIndexComponent, public NRTYMerger::ISerializableObjectsFactory {
public:
    TRTYMakeupIndexComponent(const TRTYServerConfig& config);

    virtual NRTYMerger::IHeader::TPtr BuildDefaultHeader() const override;
    virtual NRTYMerger::IObject::TPtr BuildDefaultObject() const override;
    virtual NRTYServer::IComponentParser::TPtr BuildParser() const override;
    virtual NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    virtual THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    virtual THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    virtual const TIndexFiles& GetIndexFiles() const override;

    virtual bool DoMerge(const NRTYServer::TMergeContext& context) const override;
    virtual TString GetName() const override {
        return MAKEUP_COMPONENT_NAME;
    }
    virtual bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    virtual void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    virtual bool GetInfoChecker(NRTYServer::TInfoChecker& info) const override;

private:
    const TRTYServerConfig& Config;
    TIndexFiles IndexFiles;

    static TFactory::TRegistrator<TRTYMakeupIndexComponent> Registrator;
};

typedef TAtomicSharedPtr<TRTYMakeupIndexComponent> TRTYMakeupIndexComponentPtr;
