#pragma once

#include "zones_description.h"
#include "makeup_storage_interface.h"
#include <saas/rtyserver/config/fwd.h>
#include <kernel/externalrelev/sent_zones.h>
#include <saas/util/transaction.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <kernel/snippets/iface/sentsfilter.h>

class TRTYMakeupManager: public ISentenceZonesReader, public IMakeupStorage, public NRTYServer::IIndexComponentManager, public NSnippets::ISentsFilter {
public: // ISentenceZonesReader
    bool GetFeatureIndex(const NZoneFactors::TZoneFactorType factor, const ui32 zoneNumber, const EFormClass matchLevel, ui32& featureIndex) const override;
    ui32 GetNumberOfZones() const override;
    ui32 GetZoneAvgLength(const ui32 zoneNumber) const override;
public: // ISentsFilter
    bool IsPermitted(int docId, int sentId) const override;
public: // IMakeupStorage
    bool GetDoClean() const override;
    NZonesMakeup::IZonesDescription* GetZonesDescription() override;
    const NZonesMakeup::IZonesDescription* GetZonesDescription() const override;
public: // NRTYServer::IIndexComponentManager
    bool DoOpen() override;
    bool DoClose() override { return true; }
    bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) override;
    void InitInteractions(const NRTYServer::IIndexManagersStorage& /* storage */) override {}
    bool GetDocInfo(const ui32 docId, NJson::TJsonValue& result) const override;
public:
    TRTYMakeupManager(const TString& hdrFileToOpen, const TString& docsFileToOpen, const TRTYServerConfig& config, bool useMemoryPool, bool doClean);
    void PrintPoolSizes() const;
    static const TString HdrFileName;
    static const TString DocsFileName;
    void Deserialize(IInputStream& hdrIn, IInputStream& docsIn);
    static const int SerializeVersion;

protected:
    virtual void DeserializeDocuments(IInputStream& in, ui32 version, ui32 countDocs) = 0;
    virtual bool IsCorrectDocument(ui32 docid) const = 0;
    virtual ui32 GetSentsCount(ui32 docid) const = 0;

protected:
    THolder<TZonesDescription> ZonesDescription;
    TString HdrFileToOpen;
    TString DocsFileToOpen;
private:
    TOptionalAllocator SpansZonesAllocator;
    TOptionalAllocator LengthZonesAllocator;
    TOptionalAllocator SentsMakeupAllocator;
    const TRTYServerConfig& Config;
    bool DoClean;
    TMutex MutexNumberOfZones;
    mutable ui32 CachedZonesNumber = Max<ui32>();
};
