#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>

class TRTYMakeupParsedEntity : public TParsedDocument::TParsedEntity {
public:
    TRTYMakeupParsedEntity(TConstructParams& params);

    bool HasMakeup() const {
        return !!Makeup;
    }

    const TString& GetMakeup() const {
        return Makeup;
    }

    TString& MutableMakeup() const {
        return Makeup;
    }

protected:
    virtual void DoApplyPatch(const TParsedDocument& doc);

private:
    mutable TString Makeup;
};
