#pragma once
#include "makeup_allocators_storage.h"
#include "zones_description_interface.h"
#include <kernel/externalrelev/sent_zones.h>
#include <library/cpp/html/face/parstypes.h>

class IMakeupStorage {
public:
    virtual bool GetDoClean() const = 0;
    virtual NZonesMakeup::IZonesDescription* GetZonesDescription() = 0;
    virtual const NZonesMakeup::IZonesDescription* GetZonesDescription() const = 0;
    virtual TMakeupAllocatorsStorage& GetAllocatorsStorage() = 0;
    virtual ~IMakeupStorage() {}
};

class IMakeupWritableStorage {
public:
    virtual void StoreZone(ui32 docid, NZonesMakeup::TZoneNumber, ui16 sentBegin, ui16 wordBegin, ui32 wordBeginInDoc, ui16 sentEnd, ui16 wordEnd, ui32 wordEndInDoc) = 0;
    virtual void MarkDocNoZones(ui32 docId) = 0;
    virtual void BuildMakeup(ui32 docId) = 0;
    virtual NZonesMakeup::TZoneNumber DecodeZone(const TString& name) = 0;
    virtual void AddZone(const TString& name) = 0;
    virtual void AddZoneUnsafe(const TString& name) = 0;
    virtual TOptionalAllocator& GetTempStorageAllocator() = 0;
    virtual ~IMakeupWritableStorage() {}
};

class IMakeupWritableStorageOwner {
public:
    virtual IMakeupWritableStorage* GetMakeupStorage() = 0;
    virtual ~IMakeupWritableStorageOwner() {}
};
