#include "position.h"

namespace NZonesMakeup {
    TPosition::TPosition()
        : Sent(0)
        , Word(0)
        , WordInDoc(0)
    {}

    TPosition::TPosition(ui16 sent, ui16 word, ui16 wordInDoc)
        : Sent(sent)
        , Word(word)
        , WordInDoc(wordInDoc)
    {}

    bool TPosition::operator < (const TPosition& right) const {
        return Hash() < right.Hash();
    }

    bool TPosition::operator == (const TPosition& other) const {
        return Hash() == other.Hash();
    }

    bool TPosition::operator != (const TPosition& other) const {
        return !operator == (other);
    }

    void TPosition::Serialize(IOutputStream& out) const {
        out.Write(&Sent, sizeof(Sent));
        out.Write(&Word, sizeof(Word));
        out.Write(&WordInDoc, sizeof(WordInDoc));
    }

    void TPosition::Deserialize(IInputStream& in, int /*version*/) {
        in.Load(&Sent, sizeof(Sent));
        in.Load(&Word, sizeof(Word));
        in.Load(&WordInDoc, sizeof(WordInDoc));
    }
}
